	function [S1, S2] = L_PHASE_LATTICE_RICHARDS_H(alfa, M, wT)
	
	% 	Computes the frequency response for the even and odd  
	%	branches in a linear-phase lattice filter with first-
	%	and second-order cascaded Richards' sections in parallel 
	%	with M delay elements. 
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar, 2010-10-08
	% 	Modified by: 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:		Works only for M = even
	% 	Report bugs to:	Wanhammar@gmail.com
	
	if mod(M,2) == 1
		disp('Not yet implemented')
		stop
	end
	ewT = exp(i*wT);
	ewT2 = exp(i*wT*2);	
	N = length(alfa);
	
	% Odd branch
	S1 = (1-alfa(1)*ewT)./(ewT-alfa(1));
	for k = 2:2:N-1
		a = alfa(k+1)*(1-alfa(k));
		S1 = -S1.*(-alfa(k)*ewT2-a*ewT+1)./(ewT2-a*ewT-alfa(k));
	end
	% Delay branch
	S2 = exp(-i*M*wT);
